package pt.cff.tp05_03;

import android.content.SharedPreferences;
import android.os.Bundle;
import android.widget.EditText;
import androidx.appcompat.app.AppCompatActivity;

public class MainActivity extends AppCompatActivity {

    private static final String MYSHPREFS="MySharedPrefences";
    private static final String MYKEY="MyKey";
    private String value;
    private EditText et;
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        et = (EditText) findViewById(R.id.editText);
    }
    @Override
    protected void onStart() {
        super.onStart();
        SharedPreferences settings = getSharedPreferences(MYSHPREFS,0);
        value = settings.getString(MYKEY, "");
        et.setText(value);
    }
    @Override
    protected void onStop() {
        super.onStop();
        SharedPreferences settings = getSharedPreferences(MYSHPREFS,0);
        SharedPreferences.Editor editor = settings.edit();
        value = et.getText().toString();
        editor.putString(MYKEY, value);
        editor.apply();
    }
}
